package gov.va.vamf.scheduling.communitycare.resource;

import com.agilex.healthcare.veteranappointment.resources.AbstractUserResource;
import gov.va.vamf.scheduling.communitycare.domain.CCTypeOfCare;
import gov.va.vamf.scheduling.communitycare.service.CCService;
import gov.va.vamf.security.v1.VamfJwtClaimsConstants;
import gov.va.vamf.security.v1.filters.JwtRbacRestricted;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import java.util.List;

@Path("/community-care-services")
@Component
@Scope("request")
public class CommunityCareResource extends AbstractUserResource {

	@Resource
	private CCService ccService;

	/**
	 * Fetch CC type of care information from Mongo DB.
	 * @return CCTypeOfCare
	 */
	@GET
	@Path("/type-of-cares")
	@Produces({"application/xml", "application/json"})
	@JwtRbacRestricted(VamfJwtClaimsConstants.VAMF_ROLE_VETERAN)
	public Response getCCTypeOfCares()
	{
		List<CCTypeOfCare> ccTypeOfCares = ccService.fetchAllCCTypeOfCaresFromMongo();

		return Response.ok(ccTypeOfCares).build();
	}
}